/*== MT8820 Radio Communication Analyzer ===============*/
/*    Modification History: 
   12 Oct 2002 changed by Usami 
   17 Jan 2003 changed by Scott 
   25 Jul 2003 - [V3.0],Anritsu MCA1,New Released
   01 Sep 2003 - [V3.1],Anritsu MCA1,Added:ALLMEAS? GPRSBER
        					         Modified:BER?/BER_SAMPLE[?]/LBTYPE[?]
        
*/
/*===========================================================================*/
/*  Please do not use global variables or arrays in the include file of      */
/*  instrument drivers that will be submitted for inclusion into the         */
/*  LabWindows Instrument Driver Library.                                    */
/*===========================================================================*/

#ifndef  __MT8820_HEADER_GSM
#define __MT8820_HEADER_GSM

#include <visatype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*****************************************************************************/
/*					            	GPRS
		      The following values are defined for GPRS 						 */
/*****************************************************************************/	

#define AUMT8820_OPERATING_MODE_GSM      0
#define AUMT8820_OPERATING_MODE_GPRS     1

#define AUMT8820_EXTERNAL_DOWN_LINK_LOSS_BAND_1      0
#define AUMT8820_EXTERNAL_DOWN_LINK_LOSS_BAND_2      1
#define AUMT8820_EXTERNAL_DOWN_LINK_LOSS_BAND_3      2

#define AUMT8820_EXTERNAL_UP_LINK_LOSS_BAND_1      0
#define AUMT8820_EXTERNAL_UP_LINK_LOSS_BAND_2      1
#define AUMT8820_EXTERNAL_UP_LINK_LOSS_BAND_3      2

#define AUMT8820_EXTERNAL_AUX_LOSS_BAND_1      0
#define AUMT8820_EXTERNAL_AUX_LOSS_BAND_2      1
#define AUMT8820_EXTERNAL_AUX_LOSS_BAND_3      2

#define AUMT8820_EXTERNAL_LOSS_MODE_ON       0
#define AUMT8820_EXTERNAL_LOSS_MODE_OFF      1

#define AUMT8820_OUTPUT_LEVEL_CORRECTION_CCH      0
#define AUMT8820_OUTPUT_LEVEL_CORRECTION_TCH      1

#define AUMT8820_CONNECTION_TYPE_TEST_MODE_A      0
#define AUMT8820_CONNECTION_TYPE_BLER             1
#define AUMT8820_CONNECTION_TYPE_EXT_PACKET_DATA  2

#define AUMT8820_CODING_SCHEME_CS_1      0
#define AUMT8820_CODING_SCHEME_CS_2      1
#define AUMT8820_CODING_SCHEME_CS_3      2
#define AUMT8820_CODING_SCHEME_CS_4      3

#define AUMT8820_NET_BIT_RATE_13_0_KBPS      0
#define AUMT8820_NET_BIT_RATE_12_2_KBPS      1
#define AUMT8820_NET_BIT_RATE_11_4_KBPS      2
#define AUMT8820_NET_BIT_RATE_10_2_KBPS      3
#define AUMT8820_NET_BIT_RATE_7_95_KBPS      4
#define AUMT8820_NET_BIT_RATE_7_40_KBPS      5
#define AUMT8820_NET_BIT_RATE_6_70_KBPS      6
#define AUMT8820_NET_BIT_RATE_5_90_KBPS      7
#define AUMT8820_NET_BIT_RATE_4_75_KBPS      8

#define AUMT8820_MULTI_SLOT_CONFIGURATION_1DL_1UL      0
#define AUMT8820_MULTI_SLOT_CONFIGURATION_2DL_1UL      1
#define AUMT8820_MULTI_SLOT_CONFIGURATION_2DL_2UL      2
#define AUMT8820_MULTI_SLOT_CONFIGURATION_3DL_1UL      3
#define AUMT8820_MULTI_SLOT_CONFIGURATION_3DL_2UL      4
#define AUMT8820_MULTI_SLOT_CONFIGURATION_4DL_1UL      5

#define AUMT8820_NETWORK_CONTROL_MODE_NC0      0
#define AUMT8820_NETWORK_CONTROL_MODE_NC1      1
#define AUMT8820_NETWORK_CONTROL_MODE_NC2      2
#define AUMT8820_NETWORK_CONTROL_MODE_RESET    3

#define AUMT8820_BLOCK_ERROR_RATE_MEASUREMENT_MODE_ON      0
#define AUMT8820_BLOCK_ERROR_RATE_MEASUREMENT_MODE_OFF     1

#define AUMT8820_LIMIT_SETTING_WINDOW_LIMIT_SETTING      0

#define AUMT8820_BLOCK_ERROR_RATE_TOTAL_PASS             0
#define AUMT8820_BLOCK_ERROR_RATE_TOTAL_FAIL             4
#define AUMT8820_BLOCK_ERROR_RATE_TOTAL_NO_JUDGEMENT_YET 9

#define AUMT8820_C_VALUE_QUERY_RECEIVES                     0
#define AUMT8820_C_VALUE_QUERY_DOES_NOT_RECEIVE             1

#define AUMT8820_SIGNAL_VARIANCE_QUERY_RECEIVES             0
#define AUMT8820_SIGNAL_VARIANCE_QUERY_DOES_NOT_RECEIVE     1

#define AUMT8820_INTERFERENCE_LEVEL_QUERY_RECEIVES          0
#define AUMT8820_INTERFERENCE_LEVEL_QUERY_DOES_NOT_RECEIVE  1


/*****************************************************************************/
/*					            	GSM
		      The following values are defined for GSM 						 */
/*****************************************************************************/	

#define AUMT8820_AUDIO_INPUT_OUTPUT_CONNECTOR__HANDSET      0
#define AUMT8820_AUDIO_INPUT_OUTPUT_CONNECTOR__AUDIO_IO     1

#define AUMT8820_UNIT_HZ  0
#define AUMT8820_UNIT_PPM 1

#define AUMT8820_UNIT2_DBM  0
#define AUMT8820_UNIT2_WATT 1

#define AUMT8820_UNIT3_DBM  0
#define AUMT8820_UNIT3_DB   1

#define AUMT8820_OFFSET_FREQUENCY_0KHZ       0
#define AUMT8820_OFFSET_FREQUENCY_100KHZ     1
#define AUMT8820_OFFSET_FREQUENCY_200KHZ     2
#define AUMT8820_OFFSET_FREQUENCY_250KHZ     3
#define AUMT8820_OFFSET_FREQUENCY_400KHZ     4
#define AUMT8820_OFFSET_FREQUENCY_600KHZ     5
#define AUMT8820_OFFSET_FREQUENCY_800KHZ     6
#define AUMT8820_OFFSET_FREQUENCY_1000KHZ    7
#define AUMT8820_OFFSET_FREQUENCY_1200KHZ    8
#define AUMT8820_OFFSET_FREQUENCY_1400KHZ    9
#define AUMT8820_OFFSET_FREQUENCY_1600KHZ    10
#define AUMT8820_OFFSET_FREQUENCY_1800KHZ    11
#define AUMT8820_OFFSET_FREQUENCY_2000KHZ    12

#define AUMT8820_AVERAGE_TEMPLATE_JUDGMENT_PASS  0
#define AUMT8820_AVERAGE_TEMPLATE_JUDGMENT_FAIL  1
#define AUMT8820_AVERAGE_TEMPLATE_JUDGMENT_NOJUDGE  2


#define AUMT8820_MAX_TEMPLATE_JUDGMENT_PASS      0
#define AUMT8820_MAX_TEMPLATE_JUDGMENT_FAIL      1

#define AUMT8820_MIN_TEMPLATE_JUDGMENT_PASS      0
#define AUMT8820_MIN_TEMPLATE_JUDGMENT_FAIL      1

#define AUMT8820_RESULT_TEMPLATE_JUDGMENT_PASS      0
#define AUMT8820_RESULT_TEMPLATE_JUDGMENT_FAIL      1

#define AUMT8820_TYPE_FER   0
#define AUMT8820_TYPE_CIB   1
#define AUMT8820_TYPE_CII   2
#define AUMT8820_TYPE_FAST  3
#define AUMT8820_TYPE_BER   4
#define AUMT8820_TYPE_GPRSBER   5

#define AUMT8820_BIT_ERROR_RATE_INPUT_DATA_CLOCK_EDGE_RISE      0
#define AUMT8820_BIT_ERROR_RATE_INPUT_DATA_CLOCK_EDGE_FALL      1

#define AUMT8820_BIT_ERROR_RATE_INPUT_POLARITY_POSITIVE      0
#define AUMT8820_BIT_ERROR_RATE_INPUT_POLARITY_NEGATIVE      1

#define AUMT8820_BIT_ERROR_RATE_MEASUREMENT_MODE_ON      0
#define AUMT8820_BIT_ERROR_RATE_MEASUREMENT_MODE_OFF     1

#define AUMT8820_BIT_ERROR_RATE_MEASUREMENT_INPUT_RF_LOOP_BACK      0
#define AUMT8820_BIT_ERROR_RATE_MEASUREMENT_INPUT_EXTERNAL          1

#define AUMT8820_BIT_OFFSET_ZERO_BIT     0
#define AUMT8820_BIT_OFFSET_HALF_BIT     1

#define AUMT8820_CALL_PROCESSING_ON      0
#define AUMT8820_CALL_PROCESSING_OFF     1

#define AUMT8820_CALL_PROCESSING_STATUS_OFF             0
#define AUMT8820_CALL_PROCESSING_STATUS_IDLE            1
#define AUMT8820_CALL_PROCESSING_STATUS_PAGING          2
#define AUMT8820_CALL_PROCESSING_STATUS_RADIO_LINK      3
#define AUMT8820_CALL_PROCESSING_STATUS_REGISTRATION    4
#define AUMT8820_CALL_PROCESSING_STATUS_ORIGINATION     5
#define AUMT8820_CALL_PROCESSING_STATUS_TERMINATION     6
#define AUMT8820_CALL_PROCESSING_STATUS_COMMUNICATION   7
#define AUMT8820_CALL_PROCESSING_STATUS_HANDOVER        8
#define AUMT8820_CALL_PROCESSING_STATUS_NW_RELEASE      9
#define AUMT8820_CALL_PROCESSING_STATUS_MS_RELEASE      10
#define AUMT8820_CALL_PROCESSING_STATUS_RADIO_DISC      11

#define AUMT8820_FLAG_RECEIVES          0
#define AUMT8820_FLAG_DOES_NOT_RECEIVE  1

#define AUMT8820_FLAG2_EXECUTED        0
#define AUMT8820_FLAG2__NOT_EXECUTED   1

#define AUMT8820_CODEC_FS       0
#define AUMT8820_CODEC_EFS      1
#define AUMT8820_CODEC_HS0      2
#define AUMT8820_CODEC_HS1      3

#define AUMT8820_HANDOVER_TYPE_INTRA_CELL      0
#define AUMT8820_HANDOVER_TYPE_INTER_CELL      1

#define AUMT8820_INPUT_LEVEL_CONTROL_POWER_CONTROL_LEVEL      0
#define AUMT8820_INPUT_LEVEL_CONTROL_MANUAL                   1

#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_COMMON       0
#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_AUDIO        1
#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_CALL_PROC    2
#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_TX_MEAS      3
#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_RX_MEAS      4
#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_FUNDAMENTAL  5

#define AUMT8820_PARAMETER_ITEMS_OPTION_STANDARD     0
#define AUMT8820_PARAMETER_ITEMS_OPTION_NON_DISPLAY  1

#define AUMT8820_LOOP_BACK_TYPE_FE        0
#define AUMT8820_LOOP_BACK_TYPE_NOFE      1
#define AUMT8820_LOOP_BACK_TYPE_FAST      2
#define AUMT8820_LOOP_BACK_TYPE_FASTSPEECH      3 

#define AUMT8820_LOOP_BACK_MODE_ON       0
#define AUMT8820_LOOP_BACK_MODE_OFF      1

#define AUMT8820_RF_OUTPUT_LEVEL_MODE_ON       0
#define AUMT8820_RF_OUTPUT_LEVEL_MODE_OFF      1

#define AUMT8820_RF_OUTPUT_LEVEL_CONTINUOUS_MODE_ON       0
#define AUMT8820_RF_OUTPUT_LEVEL_CONTINUOUS_MODE_OFF      1

#define AUMT8820_FUNDAMENTAL_MEASUREMENT_MODE_NORMAL    0
#define AUMT8820_FUNDAMENTAL_MEASUREMENT_MODE_FAST      1

#define AUMT8820_MEASUREMENT_OBJECT_NORMAL    0
#define AUMT8820_MEASUREMENT_OBJECT_RACH      1

#define AUMT8820_MODULATION_ANALYSIS_MODE_ON      0
#define AUMT8820_MODULATION_ANALYSIS_MODE_OFF     1

#define AUMT8820_MEASUREMENT_STATUS_NORMAL_TERMINATION           0
#define AUMT8820_MEASUREMENT_STATUS_LEVEL_OVER                   2
#define AUMT8820_MEASUREMENT_STATUS_LEVEL_UNDER                  3
#define AUMT8820_MEASUREMENT_STATUS_MEAS_CANNOT_BE_PERFORMED     4
#define AUMT8820_MEASUREMENT_STATUS_SYNC_WORD_CANNOT_BE_DETECTED 5
#define AUMT8820_MEASUREMENT_STATUS_ESTABLISHING_SYNC            6
#define AUMT8820_MEASUREMENT_STATUS_SYNC_LOSS                    7
#define AUMT8820_MEASUREMENT_STATUS_NOT_YET_MEASURED             9
#define AUMT8820_MEASUREMENT_STATUS_TX_MEAS_TIMEOUT              12
#define AUMT8820_MEASUREMENT_STATUS_RX_MEAS_TIMEOUT              13

#define AUMT8820_RF_OUTPUT_SPECTRUM_MODULATION_MODE_ON      0
#define AUMT8820_RF_OUTPUT_SPECTRUM_MODULATION_MODE_OFF     1

#define AUMT8820_RF_OUTPUT_SPECTRUM_SWITCHING_MODE_ON      0
#define AUMT8820_RF_OUTPUT_SPECTRUM_SWITCHING_MODE_OFF     1

#define AUMT8820_OUTPUT_SIGNAL_PATTERN_CCH      0
#define AUMT8820_OUTPUT_SIGNAL_PATTERN_TCH      1
#define AUMT8820_OUTPUT_SIGNAL_PATTERN_CCH_TCH  2

#define AUMT8820_OUTPUT_LEVEL_UNIT_DB    0
#define AUMT8820_OUTPUT_LEVEL_UNIT_DBM   1
#define AUMT8820_OUTPUT_LEVEL_UNIT_DBU   2

#define AUMT8820_PAGING_IMSI_PHONE_REPORTED     0
#define AUMT8820_PAGING_IMSI_USER_REPORTED      1

#define AUMT8820_POWER_MEASUREMENT_MODE_ON      0
#define AUMT8820_POWER_MEASUREMENT_MODE_OFF     1

#define AUMT8820_POWER_MARKER_MODE_ON      0
#define AUMT8820_POWER_MARKER_MODE_OFF     1

#define AUMT8820_POWER_STORAGE_METHOD_CURRENT      0
#define AUMT8820_POWER_STORAGE_METHOD_AVERAGE      1
#define AUMT8820_POWER_STORAGE_METHOD_MAX_HOLD     2
#define AUMT8820_POWER_STORAGE_METHOD_MIN_HOLD     3
#define AUMT8820_POWER_STORAGE_METHOD_FAILED       4

#define AUMT8820_POWER_TEMPLATE_MEASUREMENT_POSTION_ON      0
#define AUMT8820_POWER_TEMPLATE_MEASUREMENT_POSTION_OFF     1
#define AUMT8820_POWER_TEMPLATE_MEASUREMENT_POSTION_BOTH    2

#define AUMT8820_POWER_MEASUREMENT_WINDOW_1_SLOT                 0
#define AUMT8820_POWER_MEASUREMENT_WINDOW_BURST_ON_INTERVAL      1
#define AUMT8820_POWER_MEASUREMENT_WINDOW_LEADING                2
#define AUMT8820_POWER_MEASUREMENT_WINDOW_TRAILING               3

#define AUMT8820_RF_OUTPUT_SPECTRUM_RESOLUTION_BANDWIDTH_30_KHZ      0
#define AUMT8820_RF_OUTPUT_SPECTRUM_RESOLUTION_BANDWIDTH_100_KHZ     1

#define AUMT8820_ACTIVE_WINDOW_PARAMETER      0
#define AUMT8820_ACTIVE_WINDOW_FUNDAMENTAL    1
#define AUMT8820_ACTIVE_WINDOW_MS_REPORT      2
#define AUMT8820_ACTIVE_WINDOW_SYSTEM_CONFIG  3

#define AUMT8820_SCREEN_MODE_ON      0
#define AUMT8820_SCREEN_MODE_OFF     1

#define AUMT8820_SCREEN_SELECT_FUNDAMENTAL      0
#define AUMT8820_SCREEN_SELECT_PARAM_SAVE       1
#define AUMT8820_SCREEN_SELECT_PARAM_RECALL     2
#define AUMT8820_SCREEN_SELECT_SYSTEM_CONFIG    3
#define AUMT8820_SCREEN_SELECT_SYSTEM_INFO      4

#define AUMT8820_SYNCHRONOUS_SINGLE_SWEEP_COMPLETED      0
#define AUMT8820_SYNCHRONOUS_SINGLE_SWEEP_EXECUTING      1

#define AUMT8820_SYSTEM_COMBINATION_GSM_DCS1800      0
#define AUMT8820_SYSTEM_COMBINATION_GSM_PCS1900      1

#define AUMT8820_TAG_SELECT_GSM_DCS1800      0
#define AUMT8820_TAG_SELECT_GSM_PCS1900      1

#define AUMT8820_TAG_PARAM_COMMON        0
#define AUMT8820_TAG_PARAM_AUDIO         1
#define AUMT8820_TAG_PARAM_CALL_PROC     2
#define AUMT8820_TAG_PARAM_TX_MEAS       3
#define AUMT8820_TAG_PARAM_RX_MEAS       4
#define AUMT8820_TAG_PARAM_FUNDAMENTAL   5
#define AUMT8820_TAG_FUND_POWER_MEAS     6
#define AUMT8820_TAG_FUND_PWR_VS_TIME    7
#define AUMT8820_TAG_FUND_TEMPLATE       8
#define AUMT8820_TAG_FUND_MOD_ANALYSIS   9
#define AUMT8820_TAG_FUND_RF_SPEC_MOD    10
#define AUMT8820_TAG_FUND_RF_SPEC_SWITCH 11
#define AUMT8820_TAG_FUND_BIT_ERROR_RATE 12
#define AUMT8820_TAG_MSREPORT_MSREPORT   13
#define AUMT8820_TAG_SYSCFG_COMMON       14
#define AUMT8820_TAG_SYSCFG_PHONE1       15


#define AUMT8820_TEMPLATE_MODE_ON      0
#define AUMT8820_TEMPLATE_MODE_OFF     1

#define AUMT8820_TEMPLATE_CLOSE_POWER      0

#define AUMT8820_TEMPLATE_OPEN_POWER     0
#define AUMT8820_TEMPLATE_OPEN_NONE      1

#define AUMT8820_TCH_TEST_PATTERN_PN_9       0
#define AUMT8820_TCH_TEST_PATTERN_PN_15      1
#define AUMT8820_TCH_TEST_PATTERN_ALL_ZEROS  2
#define AUMT8820_TCH_TEST_PATTERN_ALL_ONES   3
#define AUMT8820_TCH_TEST_PATTERN_ECHO       4
#define AUMT8820_TCH_TEST_PATTERN_VOICE      5

#define AUMT8820_TRAINING_SEQUENCE_TSC0_0970897      0
#define AUMT8820_TRAINING_SEQUENCE_TSC1_0B778B7      1
#define AUMT8820_TRAINING_SEQUENCE_TSC2_10EE90E      2
#define AUMT8820_TRAINING_SEQUENCE_TSC3_11ED11E      3
#define AUMT8820_TRAINING_SEQUENCE_TSC4_06B906B      4
#define AUMT8820_TRAINING_SEQUENCE_TSC5_13AC13A      5
#define AUMT8820_TRAINING_SEQUENCE_TSC6_29F629F      6
#define AUMT8820_TRAINING_SEQUENCE_TSC7_3BC4BBC      7

#define AUMT8820_VOLTAGE_DISPLAY_OPEN          0
#define AUMT8820_VOLTAGE_DISPLAY_TERMINATION   1

#define AUMT8820_POWER_VS_TIME_MODE_ON      0
#define AUMT8820_POWER_VS_TIME_MODE_OFF     1

#define AUMT8820_VIEW_WINDOW_POWER          0

#define AUMT8820_WINDOW_SIZE_100_PERCENT     0
#define AUMT8820_WINDOW_SIZE_70_PERCENT      1
#define AUMT8820_WINDOW_SIZE_50_PERCENT      2
#define AUMT8820_WINDOW_SIZE_30_PERCENT      3

#define AUMT8820_PHASE_I  0
#define AUMT8820_PHASE_Q  1

#define	AUMT8820_POWER_VS_TIME_TIME1     1
#define	AUMT8820_POWER_VS_TIME_TIME2     2
#define	AUMT8820_POWER_VS_TIME_TIME3     3
#define	AUMT8820_POWER_VS_TIME_TIME4     4
#define	AUMT8820_POWER_VS_TIME_TIME5     5
#define AUMT8820_POWER_VS_TIME_TIME6     6

#define AUMT8820_TEMPLATE_JUDGE_PASS      0
#define AUMT8820_TEMPLATE_JUDGE_FAIL      4
#define AUMT8820_TEMPLATE_NOJUDGE         9

//#error In GSM!
/*****************************************************************************/
/*= Define Function Prototypes here             =============================*/
/*****************************************************************************/

/*****************************************************************************/
/*					            	GPRS
		      The following functions are defined for GPRS 					 */
/*****************************************************************************/	

ViStatus _VI_FUNC AuMT8820_Get_Block_Error_Rate(ViSession instrSession, ViReal64 _VI_FAR *ratio);
ViStatus _VI_FUNC AuMT8820_Get_Block_Error_Rate_Count(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Get_Block_Error_Rate_Fundamental_Measurement_Results(ViSession instrSession, ViChar _VI_FAR *meas_Results);
ViStatus _VI_FUNC AuMT8820_Set_Block_Error_Rate_Measurement_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Block_Error_Rate_Measurement_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Block_Error_Rate_Number_Of_Samples(ViSession instrSession, ViInt32 samples);
ViStatus _VI_FUNC AuMT8820_Get_Block_Error_Rate_Number_Of_Samples(ViSession instrSession, ViInt32 _VI_FAR *samples);
ViStatus _VI_FUNC AuMT8820_Set_Block_Error_Rate_Polling_Interval(ViSession instrSession, ViInt32 interval);
ViStatus _VI_FUNC AuMT8820_Get_Block_Error_Rate_Polling_Interval(ViSession instrSession, ViInt32 _VI_FAR *interval);
ViStatus _VI_FUNC AuMT8820_Get_Block_Error_Rate_Receive_Count(ViSession instrSession, ViReal64 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Get_Block_Error_Rate_Total(ViSession instrSession, ViInt32 _VI_FAR *judgement, ViReal64 _VI_FAR *ratio, ViInt32 _VI_FAR *error_count, ViInt32 _VI_FAR *received_block, ViInt32 _VI_FAR *samples);
ViStatus _VI_FUNC AuMT8820_Get_C_Value_Query(ViSession instrSession, ViInt32 _VI_FAR *flag, ViInt32 _VI_FAR *result);
ViStatus _VI_FUNC AuMT8820_Set_Coding_Scheme(ViSession instrSession, ViInt32 scheme);
ViStatus _VI_FUNC AuMT8820_Get_Coding_Scheme(ViSession instrSession,  ViInt32  _VI_FAR *scheme);
ViStatus _VI_FUNC AuMT8820_Set_Connection_Type(ViSession instrSession, ViInt32 type);
ViStatus _VI_FUNC AuMT8820_Get_Connection_Type(ViSession instrSession,  ViInt32  _VI_FAR *type);
ViStatus _VI_FUNC AuMT8820_Set_External_Aux_Loss(ViSession instrSession, ViInt32 band, ViReal64 loss);
ViStatus _VI_FUNC AuMT8820_Get_External_Aux_Loss(ViSession instrSession,  ViInt32  band, ViReal64 _VI_FAR *loss);
ViStatus _VI_FUNC AuMT8820_Set_External_Loss_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_External_Loss_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_External_Down_Link_Loss(ViSession instrSession, ViInt32 band, ViReal64 loss);
ViStatus _VI_FUNC AuMT8820_Get_External_Down_Link_Loss(ViSession instrSession,  ViInt32  band, ViReal64 _VI_FAR *loss);
ViStatus _VI_FUNC AuMT8820_Set_External_Up_Link_Loss(ViSession instrSession, ViInt32 band, ViReal64 loss);
ViStatus _VI_FUNC AuMT8820_Get_External_Up_Link_Loss(ViSession instrSession,  ViInt32  band, ViReal64 _VI_FAR *loss);
ViStatus _VI_FUNC AuMT8820_Get_Interference_Level_Query(ViSession instrSession, ViInt32 slot, ViInt32 _VI_FAR *flag, ViInt32 _VI_FAR *result);
ViStatus _VI_FUNC AuMT8820_Set_Limit_Setting_Window(ViSession instrSession, ViInt32 open_Window);
ViStatus _VI_FUNC AuMT8820_Get_Limit_Setting_Window(ViSession instrSession,  ViInt32  _VI_FAR *open_Window);
ViStatus _VI_FUNC AuMT8820_Set_Location_ID_RAC(ViSession instrSession, ViInt32 slot);
ViStatus _VI_FUNC AuMT8820_Get_Location_ID_RAC(ViSession instrSession, ViInt32 _VI_FAR *slot);
ViStatus _VI_FUNC AuMT8820_Set_Multi_Slot_Configuration(ViSession instrSession, ViInt32 configuration);
ViStatus _VI_FUNC AuMT8820_Get_Multi_Slot_Configuration(ViSession instrSession,  ViInt32  _VI_FAR *configuration);
ViStatus _VI_FUNC AuMT8820_Set_Net_Bit_Rate(ViSession instrSession, ViInt32 rate);
ViStatus _VI_FUNC AuMT8820_Get_Net_Bit_Rate(ViSession instrSession,  ViInt32  _VI_FAR *rate);
ViStatus _VI_FUNC AuMT8820_Set_Network_Control_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Network_Control_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Operating_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Operating_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Output_Level_Correction(ViSession instrSession, ViInt32 channel);
ViStatus _VI_FUNC AuMT8820_Get_Output_Level_Correction(ViSession instrSession,  ViInt32  _VI_FAR *channel);
ViStatus _VI_FUNC AuMT8820_Get_Signal_Variance_Query(ViSession instrSession, ViInt32 _VI_FAR *flag, ViInt32 _VI_FAR *result);



/*****************************************************************************/
/*					            	GSM
		      The following functions are defined for GSM 					 */
/*****************************************************************************/	

ViStatus _VI_FUNC AuMT8820_Band_Calibration(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Call_Start(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Call_Stop(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Close_View_Window(ViSession instrSession, ViInt32 view);
ViStatus _VI_FUNC AuMT8820_Full_Calibration(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Power_Template_Standard(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Refresh_Call_Status(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Set_Active_Window(ViSession instrSession, ViInt32 window);
ViStatus _VI_FUNC AuMT8820_Get_Active_Window(ViSession instrSession,  ViInt32  _VI_FAR *window);
ViStatus _VI_FUNC AuMT8820_Get_Adjacent_Cell_Monitoring(ViSession instrSession, ViInt32 cell_in, ViInt32 _VI_FAR *flag, ViInt32 _VI_FAR *cell, ViInt32 _VI_FAR *arfcn, ViInt32 _VI_FAR *rxlev, ViInt32 _VI_FAR *ncc, ViInt32 _VI_FAR *bcc);
ViStatus _VI_FUNC AuMT8820_Set_Audio_Input_Level(ViSession instrSession, ViReal64 level);
ViStatus _VI_FUNC AuMT8820_Get_Audio_Input_Level(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Set_Audio_Input_Output_Connector(ViSession instrSession, ViInt32 connector);
ViStatus _VI_FUNC AuMT8820_Get_Audio_Input_Output_Connector(ViSession instrSession,  ViInt32  _VI_FAR *connector);
ViStatus _VI_FUNC AuMT8820_Set_Audio_Output_Level(ViSession instrSession, ViReal64 Level);
ViStatus _VI_FUNC AuMT8820_Get_Audio_Output_Level(ViSession instrSession, ViReal64 _VI_FAR *Level);
ViStatus _VI_FUNC AuMT8820_Set_All_Fundamental_Measurement_Items(ViSession instrSession, ViChar _VI_FAR items[]);
ViStatus _VI_FUNC AuMT8820_Get_All_Fundamental_Measurement_Items(ViSession instrSession, ViChar _VI_FAR items[]);
ViStatus _VI_FUNC AuMT8820_Get_All_Fundamental_Measurement_Results(ViSession instrSession, ViChar _VI_FAR meas_Results[]); 
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Count(ViSession instrSession, ViInt32 type, ViReal64 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Fundamental_Measurement_Results(ViSession instrSession, ViChar _VI_FAR *meas_Results);
ViStatus _VI_FUNC AuMT8820_Set_Bit_Error_Rate_Input_Data_Clock_Edge(ViSession instrSession, ViInt32 clock_Edge);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Input_Data_Clock_Edge(ViSession instrSession,  ViInt32  _VI_FAR *clock_Edge);
ViStatus _VI_FUNC AuMT8820_Set_Bit_Error_Rate_Input_Polarity(ViSession instrSession, ViInt32 polarity);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Input_Polarity(ViSession instrSession,  ViInt32  _VI_FAR *polarity);
ViStatus _VI_FUNC AuMT8820_Set_Bit_Error_Rate_Measurement_Input(ViSession instrSession, ViInt32 input);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Measurement_Input(ViSession instrSession,  ViInt32  _VI_FAR *input);
ViStatus _VI_FUNC AuMT8820_Set_Bit_Error_Rate_Measurement_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Measurement_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Bit_Error_Rate_Number_Of_Samples(ViSession instrSession, ViInt32 type, ViInt32 number);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Number_Of_Samples(ViSession instrSession, ViInt32 type, ViInt32 _VI_FAR *number);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Ratio(ViSession instrSession, ViInt32 type, ViReal64 _VI_FAR *ratio);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Received_Bits(ViSession instrSession, ViInt32 type, ViReal64 _VI_FAR *bits);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Total(ViSession instrSession, ViInt32 type,ViInt32 *judgment, ViReal64 _VI_FAR *rate, ViReal64 _VI_FAR *error_bits, ViReal64 _VI_FAR *rx_bits, ViReal64 _VI_FAR *sample_bits);
ViStatus _VI_FUNC AuMT8820_Set_Bit_Offset(ViSession instrSession, ViInt32 offset);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Offset(ViSession instrSession,  ViInt32  _VI_FAR *offset);
ViStatus _VI_FUNC AuMT8820_Get_Call_Processing_Error(ViSession instrSession, ViInt32 _VI_FAR *seq_code, ViInt32 _VI_FAR *err_code);
ViStatus _VI_FUNC AuMT8820_Set_Call_Processing_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Call_Processing_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Get_Call_Processing_Result(ViSession instrSession, ViInt32 seq_code, ViInt32 _VI_FAR *flag, ViInt32 _VI_FAR *err_code);
ViStatus _VI_FUNC AuMT8820_Get_Call_Processing_Status(ViSession instrSession, ViInt32 _VI_FAR *code);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency(ViSession instrSession, ViReal64 _VI_FAR *frequency);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency_Average(ViSession instrSession, ViReal64 _VI_FAR *frequency);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency_Error(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *frequency);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency_Error_Average(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *frequency);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency_Error_Maximum(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *frequency);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency_Error_Minimum(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *frequency);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency_Error_Total(ViSession instrSession, ViInt32 unit, ViInt32 *judgment, ViReal64 _VI_FAR *avg_freq, ViReal64 _VI_FAR *max_freq, ViReal64 _VI_FAR *min_freq);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Off_Power(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Off_Power_Average(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Off_Power_Maximum(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Off_Power_Minimum(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Off_Power_Total(ViSession instrSession, ViInt32 unit, ViInt32 *judgment, ViReal64 _VI_FAR *avg_level, ViReal64 _VI_FAR *max_level, ViReal64 _VI_FAR *min_level);
ViStatus _VI_FUNC AuMT8820_Set_CCH_Channel(ViSession instrSession, ViInt32 channel);
ViStatus _VI_FUNC AuMT8820_Get_CCH_Channel(ViSession instrSession, ViInt32 _VI_FAR *channel);
ViStatus _VI_FUNC AuMT8820_Set_CCH_Downlink_Frequency(ViSession instrSession, ViReal64 Frequency);
ViStatus _VI_FUNC AuMT8820_Get_CCH_Downlink_Frequency(ViSession instrSession, ViReal64 _VI_FAR *Frequency);
ViStatus _VI_FUNC AuMT8820_Set_CCH_Uplink_Frequency(ViSession instrSession, ViReal64 Frequency);
ViStatus _VI_FUNC AuMT8820_Get_CCH_Uplink_Frequency(ViSession instrSession, ViReal64 _VI_FAR *Frequency);
ViStatus _VI_FUNC AuMT8820_Set_Codec(ViSession instrSession, ViInt32 type);
ViStatus _VI_FUNC AuMT8820_Get_Codec(ViSession instrSession,  ViInt32  _VI_FAR *type);
ViStatus _VI_FUNC AuMT8820_Set_Encoder_Input_Gain(ViSession instrSession, ViReal64 level);
ViStatus _VI_FUNC AuMT8820_Get_Encoder_Input_Gain(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Set_Fundamental_Measurement_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Fundamental_Measurement_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Get_GPRS_Bit_Error_Rate_Fundamental_Measurement_Results(ViSession instrSession, ViChar _VI_FAR *meas_Results);   
ViStatus _VI_FUNC AuMT8820_Set_Handover_Type(ViSession instrSession, ViInt32 type);
ViStatus _VI_FUNC AuMT8820_Get_Handover_Type(ViSession instrSession,  ViInt32  _VI_FAR *type);
ViStatus _VI_FUNC AuMT8820_Set_Handset_Microphone_Volume(ViSession instrSession, ViInt32 volume);
ViStatus _VI_FUNC AuMT8820_Get_Handset_Microphone_Volume(ViSession instrSession, ViInt32 _VI_FAR *volume);
ViStatus _VI_FUNC AuMT8820_Set_Handset_Speaker_Volume(ViSession instrSession, ViInt32 volume);
ViStatus _VI_FUNC AuMT8820_Get_Handset_Speaker_Volume(ViSession instrSession, ViInt32 _VI_FAR *volume);
ViStatus _VI_FUNC AuMT8820_Get_IMEI_Query(ViSession instrSession, ViInt32 _VI_FAR *flag, ViInt32 _VI_FAR *id);
ViStatus _VI_FUNC AuMT8820_Get_IMSI_Query(ViSession instrSession, ViInt32 _VI_FAR *flag, ViInt32 _VI_FAR *id);
ViStatus _VI_FUNC AuMT8820_Set_Int_Mobile_Sub_Identity(ViSession instrSession, ViChar _VI_FAR id[]);
ViStatus _VI_FUNC AuMT8820_Get_Int_Mobile_Sub_Identity(ViSession instrSession, ViChar _VI_FAR id[]);
ViStatus _VI_FUNC AuMT8820_Set_Input_Level(ViSession instrSession, ViReal64 Level);
ViStatus _VI_FUNC AuMT8820_Get_Input_Level(ViSession instrSession, ViReal64 _VI_FAR *Level);
ViStatus _VI_FUNC AuMT8820_Set_Input_Level_Control(ViSession instrSession, ViInt32 type);
ViStatus _VI_FUNC AuMT8820_Get_Input_Level_Control(ViSession instrSession,  ViInt32  _VI_FAR *type);
ViStatus _VI_FUNC AuMT8820_Set_Location_ID(ViSession instrSession, ViInt32 id);
ViStatus _VI_FUNC AuMT8820_Get_Location_ID(ViSession instrSession, ViInt32 _VI_FAR *id);
ViStatus _VI_FUNC AuMT8820_Set_Location_ID_MCC(ViSession instrSession, ViInt32 id);
ViStatus _VI_FUNC AuMT8820_Get_Location_ID_MCC(ViSession instrSession, ViInt32 _VI_FAR *id);
ViStatus _VI_FUNC AuMT8820_Set_Location_ID_MNC(ViSession instrSession, ViInt32 id);
ViStatus _VI_FUNC AuMT8820_Get_Location_ID_MNC(ViSession instrSession, ViInt32 _VI_FAR *id);
ViStatus _VI_FUNC AuMT8820_Set_Loop_Back_Type(ViSession instrSession, ViInt32 type);
ViStatus _VI_FUNC AuMT8820_Get_Loop_Back_Type(ViSession instrSession,  ViInt32  _VI_FAR *type);
ViStatus _VI_FUNC AuMT8820_Set_Loop_Back_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Loop_Back_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Get_Magnitude_Error(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Magnitude_Error_Average(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Magnitude_Error_Maximum(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Magnitude_Error_Minimum(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Magnitude_Error_Total(ViSession instrSession, ViInt32 *judgment, ViReal64 _VI_FAR *avg_percent, ViReal64 _VI_FAR *max_percent, ViReal64 _VI_FAR *min_percent);
ViStatus _VI_FUNC AuMT8820_Set_Measurement_Object(ViSession instrSession, ViInt32 object);
ViStatus _VI_FUNC AuMT8820_Get_Measurement_Object(ViSession instrSession,  ViInt32  _VI_FAR *object);
ViStatus _VI_FUNC AuMT8820_Set_Measurement_Slot(ViSession instrSession, ViInt32 slot);
ViStatus _VI_FUNC AuMT8820_Get_Measurement_Slot(ViSession instrSession, ViInt32 _VI_FAR *slot);
ViStatus _VI_FUNC AuMT8820_Get_Measurement_Status(ViSession instrSession, ViInt32 _VI_FAR *status);
ViStatus _VI_FUNC AuMT8820_Get_Mod_Analysis_Fundamental_Measurement_Results(ViSession instrSession, ViChar _VI_FAR *meas_Results);
ViStatus _VI_FUNC AuMT8820_Set_Modulation_Analysis_Count(ViSession instrSession, ViInt32 count);
ViStatus _VI_FUNC AuMT8820_Get_Modulation_Analysis_Count(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Set_Modulation_Analysis_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Modulation_Analysis_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Get_MS_Power_Class(ViSession instrSession, ViInt32 _VI_FAR *flag, ViInt32 _VI_FAR *class);
ViStatus _VI_FUNC AuMT8820_Set_MS_Power_Level(ViSession instrSession, ViInt32 level);
ViStatus _VI_FUNC AuMT8820_Get_MS_Power_Level(ViSession instrSession, ViInt32 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_MS_Power_Level_And_Timing_Advance(ViSession instrSession, ViInt32 _VI_FAR *flag, ViInt32 _VI_FAR *level, ViInt32 _VI_FAR *value);
ViStatus _VI_FUNC AuMT8820_Set_Multiframe_Paging_Period(ViSession instrSession, ViInt32 num);
ViStatus _VI_FUNC AuMT8820_Get_Multiframe_Paging_Period(ViSession instrSession, ViInt32 _VI_FAR *num);
ViStatus _VI_FUNC AuMT8820_Set_Neighbour_Cell_Channel(ViSession instrSession, ViInt32 cell, ViInt32 channel);
ViStatus _VI_FUNC AuMT8820_Get_Neighbour_Cell_Channel(ViSession instrSession, ViInt32 cell, ViInt32 _VI_FAR *channel);
ViStatus _VI_FUNC AuMT8820_Set_Network_ID_BCC(ViSession instrSession, ViInt32 id);
ViStatus _VI_FUNC AuMT8820_Get_Network_ID_BCC(ViSession instrSession, ViInt32 _VI_FAR *id);
ViStatus _VI_FUNC AuMT8820_Set_Network_ID_NCC(ViSession instrSession, ViInt32 id);
ViStatus _VI_FUNC AuMT8820_Get_Network_ID_NCC(ViSession instrSession, ViInt32 _VI_FAR *id);
ViStatus _VI_FUNC AuMT8820_Get_Network_Phone_Number_Query(ViSession instrSession, ViInt32 _VI_FAR *flag, ViInt32 _VI_FAR *number);
ViStatus _VI_FUNC AuMT8820_Set_Open_View_Window(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Open_View_Window(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Output_Level(ViSession instrSession, ViReal64 level, ViInt32 units);
ViStatus _VI_FUNC AuMT8820_Get_Output_Level(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Set_Output_Signal_Pattern(ViSession instrSession, ViInt32 pattern);
ViStatus _VI_FUNC AuMT8820_Get_Output_Signal_Pattern(ViSession instrSession,  ViInt32  _VI_FAR *pattern);
ViStatus _VI_FUNC AuMT8820_Set_Paging_IMSI(ViSession instrSession, ViInt32 type);
ViStatus _VI_FUNC AuMT8820_Get_Paging_IMSI(ViSession instrSession,  ViInt32  _VI_FAR *type);
ViStatus _VI_FUNC AuMT8820_Set_Parameter_Items_Displayed(ViSession instrSession, ViInt32 tag, ViInt32 option);
ViStatus _VI_FUNC AuMT8820_Get_Parameter_Items_Displayed(ViSession instrSession, ViInt32  tag, ViInt32  _VI_FAR *option);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Phase_Error_Average(ViSession instrSession, ViReal64 _VI_FAR *degrees);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Phase_Error_Maximum(ViSession instrSession, ViReal64 _VI_FAR *degrees);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Phase_Error_Minimum(ViSession instrSession, ViReal64 _VI_FAR *degree);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Phase_Vector_Error(ViSession instrSession, ViReal64 _VI_FAR *degree);
ViStatus _VI_FUNC AuMT8820_Get_PEAK_Phase_Vector_Error_Total(ViSession instrSession, ViInt32 *judgment, ViReal64 _VI_FAR *avg_deg, ViReal64 _VI_FAR *max_deg, ViReal64 _VI_FAR *min_deg);
ViStatus _VI_FUNC AuMT8820_Get_Power_Flatness_MAX_Power_Average(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Flatness_MAX_Power_Maximum(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Flatness_MAX_Power_Minimum(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Flatness_MAX_Power_Total(ViSession instrSession, ViInt32 *judgment, ViReal64 _VI_FAR *avg_level, ViReal64 _VI_FAR *max_level, ViReal64 _VI_FAR *min_level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Flatness_Maximum(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Flatness_MIN_Power_Average(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Flatness_MIN_Power_Maximum(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Flatness_MIN_Power_Minimum(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Flatness_MIN_Power_Total(ViSession instrSession, ViInt32 *judgment, ViReal64 _VI_FAR *avg_level, ViReal64 _VI_FAR *max_level, ViReal64 _VI_FAR *min_level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Flatness_Minimum(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Marker_Level(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Set_Power_Marker_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Power_Marker_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Power_Marker_Position(ViSession instrSession, ViReal64 bit);
ViStatus _VI_FUNC AuMT8820_Get_Power_Marker_Position(ViSession instrSession, ViReal64 _VI_FAR *bit);
ViStatus _VI_FUNC AuMT8820_Get_Power_Meas_Fundamental_Measurement_Results(ViSession instrSession, ViChar _VI_FAR *meas_Results); 
ViStatus _VI_FUNC AuMT8820_Set_Power_Measurement_Count(ViSession instrSession, ViInt32 count);
ViStatus _VI_FUNC AuMT8820_Get_Power_Measurement_Count(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Set_Power_Measurement_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Power_Measurement_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Power_Measurement_Window(ViSession instrSession, ViInt32 window);
ViStatus _VI_FUNC AuMT8820_Get_Power_Measurement_Window(ViSession instrSession,  ViInt32  _VI_FAR *window);
ViStatus _VI_FUNC AuMT8820_Set_Power_Off_Template_Level_Unit(ViSession instrSession, ViInt32 unit);
ViStatus _VI_FUNC AuMT8820_Get_Power_Off_Template_Level_Unit(ViSession instrSession,  ViInt32  _VI_FAR *unit);
ViStatus _VI_FUNC AuMT8820_Get_Power_Ratio(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Ratio_Average(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Ratio_Maximum(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Ratio_Minimum(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Ratio_Total(ViSession instrSession, ViInt32 *judgment, ViReal64 _VI_FAR *avg_level, ViReal64 _VI_FAR *max_level, ViReal64 _VI_FAR *min_level);
ViStatus _VI_FUNC AuMT8820_Set_Power_Storage_Method(ViSession instrSession, ViInt32 method);
ViStatus _VI_FUNC AuMT8820_Get_Power_Storage_Method(ViSession instrSession,  ViInt32  _VI_FAR *method);
ViStatus _VI_FUNC AuMT8820_Set_Power_Template_Level(ViSession instrSession, ViInt32 line, ViReal64 level);
ViStatus _VI_FUNC AuMT8820_Get_Power_Template_Level(ViSession instrSession, ViInt32 line, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Set_Power_Template_Measurement_Postion(ViSession instrSession, ViInt32 position);
ViStatus _VI_FUNC AuMT8820_Get_Power_Template_Measurement_Postion(ViSession instrSession,  ViInt32  _VI_FAR *position);
ViStatus _VI_FUNC AuMT8820_Get_Power_Template_Result(ViSession instrSession, ViInt32 _VI_FAR *result);
ViStatus _VI_FUNC AuMT8820_Set_Power_Template_Standard(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Get_Power_VS_Time_Fundamental_Measurement_Results(ViSession instrSession, ViChar _VI_FAR *meas_Results);
ViStatus _VI_FUNC AuMT8820_Get_Power_VS_Time_Leading(ViSession instrSession, ViInt32 time, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_vs_Time_Leading_Average(ViSession instrSession, ViInt32 time, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_VS_Time_Leading_Maximum(ViSession instrSession, ViInt32 time, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_VS_Time_Leading_Minimum(ViSession instrSession, ViInt32 time, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_VS_Time_Leading_Total(ViSession instrSession, ViInt32 *judgment1, ViReal64 _VI_FAR *avg_level1, ViReal64 _VI_FAR *max_level1, ViReal64 _VI_FAR *min_level1,
                                                                                   ViInt32 *judgment2, ViReal64 _VI_FAR *avg_level2, ViReal64 _VI_FAR *max_level2, ViReal64 _VI_FAR *min_level2,
                                                                                   ViInt32 *judgment3, ViReal64 _VI_FAR *avg_level3, ViReal64 _VI_FAR *max_level3, ViReal64 _VI_FAR *min_level3,
                                                                                   ViInt32 *judgment4, ViReal64 _VI_FAR *avg_level4, ViReal64 _VI_FAR *max_level4, ViReal64 _VI_FAR *min_level4,
                                                                                   ViInt32 *judgment5, ViReal64 _VI_FAR *avg_level5, ViReal64 _VI_FAR *max_level5, ViReal64 _VI_FAR *min_level5,
                                                                                   ViInt32 *judgment6, ViReal64 _VI_FAR *avg_level6, ViReal64 _VI_FAR *max_level6, ViReal64 _VI_FAR *min_level6);
ViStatus _VI_FUNC AuMT8820_Get_Power_VS_Time_Trailing(ViSession instrSession, ViInt32 time, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_vs_Time_Trailing_Average(ViSession instrSession, ViInt32 time, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_VS_Time_Trailing_Maximum(ViSession instrSession, ViInt32 time, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_VS_Time_Trailing_Minimum(ViSession instrSession, ViInt32 time, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Power_VS_Time_Trailing_Total(ViSession instrSession, ViInt32 *judgment1, ViReal64 _VI_FAR *avg_level1, ViReal64 _VI_FAR *max_level1, ViReal64 _VI_FAR *min_level1,
                                                                                    ViInt32 *judgment2, ViReal64 _VI_FAR *avg_level2, ViReal64 _VI_FAR *max_level2, ViReal64 _VI_FAR *min_level2,
                                                                                    ViInt32 *judgment3, ViReal64 _VI_FAR *avg_level3, ViReal64 _VI_FAR *max_level3, ViReal64 _VI_FAR *min_level3,
                                                                                    ViInt32 *judgment4, ViReal64 _VI_FAR *avg_level4, ViReal64 _VI_FAR *max_level4, ViReal64 _VI_FAR *min_level4,
                                                                                    ViInt32 *judgment5, ViReal64 _VI_FAR *avg_level5, ViReal64 _VI_FAR *max_level5, ViReal64 _VI_FAR *min_level5,
                                                                                    ViInt32 *judgment6, ViReal64 _VI_FAR *avg_level6, ViReal64 _VI_FAR *max_level6, ViReal64 _VI_FAR *min_level6);
ViStatus _VI_FUNC AuMT8820_Set_Power_VS_Time_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Power_VS_Time_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Power_VS_Time_Offset_Leading(ViSession instrSession, ViInt32 time_number, ViReal64 time);
ViStatus _VI_FUNC AuMT8820_Get_Power_VS_Time_Offset_Leading(ViSession instrSession, ViInt32 time_number, ViReal64 _VI_FAR *time);
ViStatus _VI_FUNC AuMT8820_Set_Power_VS_Time_Offset_Trailing(ViSession instrSession, ViInt32 time_number, ViReal64 time);
ViStatus _VI_FUNC AuMT8820_Get_Power_VS_Time_Offset_Trailing(ViSession instrSession, ViInt32 time_number, ViReal64 _VI_FAR *time);
ViStatus _VI_FUNC AuMT8820_Get_RF_Out_Spectrum_Mod_Fundamental_Measurement_Results(ViSession instrSession, ViChar _VI_FAR *meas_Results);
ViStatus _VI_FUNC AuMT8820_Get_RF_Out_Spectrum_Switching_Fundamental_Measurement_Results(ViSession instrSession, ViChar _VI_FAR *meas_Results);
ViStatus _VI_FUNC AuMT8820_Set_RF_Output_Level_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Level_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_RF_Output_Level_Continuous_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Level_Continuous_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_RF_Output_Spectrum_Mod_Count(ViSession instrSession, ViInt32 count);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Mod_Count(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Mod_Lower(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Mod_Lower_Average(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *power);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Mod_Lower_Maximum(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Mod_Lower_Minimum(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Mod_Lower_Total(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *avg_level, ViReal64 _VI_FAR *max_level, ViReal64 _VI_FAR *min_level);
ViStatus _VI_FUNC AuMT8820_Set_RF_Output_Spectrum_Mod_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Mod_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Mod_Upper(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Mod_Upper_Average(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Mod_Upper_Maximum(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Mod_Upper_Minimum(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Mod_Upper_Total(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *avg_level, ViReal64 _VI_FAR *max_level, ViReal64 _VI_FAR *min_level);
ViStatus _VI_FUNC AuMT8820_Set_RF_Output_Spectrum_Resolution_Bandwidth(ViSession instrSession, ViInt32 filter);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Resolution_Bandwidth(ViSession instrSession,  ViInt32  _VI_FAR *filter);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Switch_Lower(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Set_RF_Output_Spectrum_Switching_Count(ViSession instrSession, ViInt32 count);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Switching_Count(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Switching_Lower_Average(ViSession instrSession, ViInt32 offset_freq, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Switching_Lower_Maximum(ViSession instrSession, ViInt32 offset_freq, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Switching_Lower_Minimum(ViSession instrSession, ViInt32 offset_freq, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Switching_Lower_Total(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *avg_level, ViReal64 _VI_FAR *max_level, ViReal64 _VI_FAR *min_level);
ViStatus _VI_FUNC AuMT8820_Set_RF_Output_Spectrum_Switching_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Switching_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Switching_Upper(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Switching_Upper_Average(ViSession instrSession, ViInt32 offset_freq, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Switching_Upper_Maximum(ViSession instrSession, ViInt32 offset_freq, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Switching_Upper_Minimum(ViSession instrSession, ViInt32 offset_freq, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_RF_Output_Spectrum_Switching_Upper_Total(ViSession instrSession, ViInt32 offset_freq, ViReal64 _VI_FAR *avg_level, ViReal64 _VI_FAR *max_level, ViReal64 _VI_FAR *min_level);
ViStatus _VI_FUNC AuMT8820_Get_RMS_Phase_Error_Average(ViSession instrSession, ViReal64 _VI_FAR *degrees);
ViStatus _VI_FUNC AuMT8820_Get_RMS_Phase_Error_Maximum(ViSession instrSession, ViReal64 _VI_FAR *degrees);
ViStatus _VI_FUNC AuMT8820_Get_RMS_Phase_Error_Minimum(ViSession instrSession, ViReal64 _VI_FAR *degree);
ViStatus _VI_FUNC AuMT8820_Get_RMS_Phase_Vector_Error(ViSession instrSession, ViReal64 _VI_FAR *degree);
ViStatus _VI_FUNC AuMT8820_Get_RMS_Phase_Vector_Error_Total(ViSession instrSession, ViInt32 *judgment, ViReal64 _VI_FAR *avg_deg, ViReal64 _VI_FAR *max_deg, ViReal64 _VI_FAR *min_deg);
ViStatus _VI_FUNC AuMT8820_Get_RX_Level_And_Quality(ViSession instrSession, ViInt32 _VI_FAR *flag, ViInt32 _VI_FAR *level, ViInt32 _VI_FAR *value);
ViStatus _VI_FUNC AuMT8820_Get_Rx_Measurement_Status(ViSession instrSession, ViInt32 _VI_FAR *status);
ViStatus _VI_FUNC AuMT8820_Set_Rx_Timeout(ViSession instrSession, ViInt32 time);
ViStatus _VI_FUNC AuMT8820_Get_Rx_Timeout(ViSession instrSession, ViInt32 _VI_FAR *time);
ViStatus _VI_FUNC AuMT8820_Set_Screen_Select(ViSession instrSession, ViInt32 screen);
ViStatus _VI_FUNC AuMT8820_Get_Screen_Select(ViSession instrSession,  ViInt32  _VI_FAR *screen);
ViStatus _VI_FUNC AuMT8820_Get_Software_Version(ViSession instrSession, ViInt32 mode, ViChar _VI_FAR version[]);
ViStatus _VI_FUNC AuMT8820_Set_Synchronous_Single_Sweep(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Get_Synchronous_Single_Sweep(ViSession instrSession,  ViInt32  _VI_FAR *state);
ViStatus _VI_FUNC AuMT8820_Set_System_Combination(ViSession instrSession, ViInt32 system);
ViStatus _VI_FUNC AuMT8820_Get_System_Combination(ViSession instrSession,  ViInt32  _VI_FAR *system);
ViStatus _VI_FUNC AuMT8820_Set_Tag_Select(ViSession instrSession, ViInt32 tag);
ViStatus _VI_FUNC AuMT8820_Get_Tag_Select(ViSession instrSession, ViInt32 window, ViInt32 _VI_FAR *tag);
ViStatus _VI_FUNC AuMT8820_Set_TCH_Channel(ViSession instrSession, ViInt32 channel);
ViStatus _VI_FUNC AuMT8820_Get_TCH_Channel(ViSession instrSession, ViInt32 _VI_FAR *channel);
ViStatus _VI_FUNC AuMT8820_Set_TCH_Downlink_Frequency(ViSession instrSession, ViReal64 Frequency);
ViStatus _VI_FUNC AuMT8820_Get_TCH_Downlink_Frequency(ViSession instrSession, ViReal64 _VI_FAR *Frequency);
ViStatus _VI_FUNC AuMT8820_Set_TCH_Slot(ViSession instrSession, ViInt32 slot);
ViStatus _VI_FUNC AuMT8820_Get_TCH_Slot(ViSession instrSession, ViInt32 _VI_FAR *slot);
ViStatus _VI_FUNC AuMT8820_Set_TCH_Test_Pattern(ViSession instrSession, ViInt32 pattern);
ViStatus _VI_FUNC AuMT8820_Get_TCH_Test_Pattern(ViSession instrSession,  ViInt32  _VI_FAR *pattern);
ViStatus _VI_FUNC AuMT8820_Set_TCH_Uplink_Frequency(ViSession instrSession, ViReal64 Frequency);
ViStatus _VI_FUNC AuMT8820_Get_TCH_Uplink_Frequency(ViSession instrSession, ViReal64 _VI_FAR *Frequency);
ViStatus _VI_FUNC AuMT8820_Set_Template_Close(ViSession instrSession, ViInt32 template);
ViStatus _VI_FUNC AuMT8820_Get_Template_Fundamental_Measurement_Results(ViSession instrSession, ViChar _VI_FAR *meas_Results);
ViStatus _VI_FUNC AuMT8820_Get_Template_Judgment_Average(ViSession instrSession, ViInt32 _VI_FAR *template);
ViStatus _VI_FUNC AuMT8820_Get_Template_Judgement_Maximum(ViSession instrSession, ViInt32 _VI_FAR *result);
ViStatus _VI_FUNC AuMT8820_Get_Template_Judgement_Minimum(ViSession instrSession, ViInt32 _VI_FAR *result);
ViStatus _VI_FUNC AuMT8820_Get_Template_Judgement_Total(ViSession instrSession, ViInt32 *judgment, ViInt32 _VI_FAR *avg_result, ViInt32 _VI_FAR *max_result, ViInt32 _VI_FAR *min_result);
ViStatus _VI_FUNC AuMT8820_Set_Template_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Template_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Template_Open(ViSession instrSession, ViInt32 template);
ViStatus _VI_FUNC AuMT8820_Get_Template_Open(ViSession instrSession,  ViInt32  _VI_FAR *template);
ViStatus _VI_FUNC AuMT8820_Get_Time_Alignment(ViSession instrSession, ViReal64 _VI_FAR *bit);
ViStatus _VI_FUNC AuMT8820_Get_Time_Alignment_Average(ViSession instrSession, ViReal64 _VI_FAR *bit);
ViStatus _VI_FUNC AuMT8820_Get_Time_Alignment_Maximum(ViSession instrSession, ViReal64 _VI_FAR *bit);
ViStatus _VI_FUNC AuMT8820_Get_Time_Alignment_Minimum(ViSession instrSession, ViReal64 _VI_FAR *bit);
ViStatus _VI_FUNC AuMT8820_Get_Time_Alignment_Total(ViSession instrSession, ViInt32 *judgment, ViReal64 _VI_FAR *avg_bit, ViReal64 _VI_FAR *max_bit, ViReal64 _VI_FAR *min_bit);
ViStatus _VI_FUNC AuMT8820_Set_Timing_Advance(ViSession instrSession, ViInt32 bit);
ViStatus _VI_FUNC AuMT8820_Get_Timing_Advance(ViSession instrSession, ViInt32 _VI_FAR *bit);
ViStatus _VI_FUNC AuMT8820_Set_Training_Sequence(ViSession instrSession, ViInt32 pattern);
ViStatus _VI_FUNC AuMT8820_Get_Training_Sequence(ViSession instrSession,  ViInt32  _VI_FAR *pattern);
ViStatus _VI_FUNC AuMT8820_Get_Tx_Measurement_Status(ViSession instrSession, ViInt32 _VI_FAR *status);
ViStatus _VI_FUNC AuMT8820_Get_Tx_Power(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_TX_Power_Average(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Tx_Power_Level(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_TX_Power_Maximum(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Tx_Power_Minimum(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_TX_Power_Total(ViSession instrSession, ViInt32 unit, ViInt32 *judgment, ViReal64 _VI_FAR *avg_level, ViReal64 _VI_FAR *max_level, ViReal64 _VI_FAR *min_level);
ViStatus _VI_FUNC AuMT8820_Set_Voltage_Display(ViSession instrSession, ViInt32 display);
ViStatus _VI_FUNC AuMT8820_Get_Voltage_Display(ViSession instrSession,  ViInt32  _VI_FAR *display);
ViStatus _VI_FUNC AuMT8820_Set_Wave_Memory_IQ(ViSession instrSession, ViInt32 iq, ViInt32 pos, ViInt32 data_in);
ViStatus _VI_FUNC AuMT8820_Get_Wave_Memory_IQ(ViSession instrSession, ViInt32 iq, ViInt32 pos, ViInt32 n, ViChar _VI_FAR data[]);
ViStatus _VI_FUNC AuMT8820_Set_Wave_Memory_Tx_Power(ViSession instrSession, ViInt32 iq, ViInt32 pos, ViInt32 data_in);
ViStatus _VI_FUNC AuMT8820_Get_Wave_Memory_Tx_Power(ViSession instrSession, ViInt32 pos, ViInt32 n, ViChar _VI_FAR data[]);
ViStatus _VI_FUNC AuMT8820_Set_Wave_Memory_Magnitude_Error(ViSession instrSession, ViInt32 pos, ViInt32 data_in);
ViStatus _VI_FUNC AuMT8820_Get_Wave_Memory_Magnitude_Error(ViSession instrSession, ViInt32 pos, ViInt32 n, ViChar _VI_FAR data[]);
ViStatus _VI_FUNC AuMT8820_Set_Wave_Memory_Phase_Error(ViSession instrSession, ViInt32 pos, ViInt32 data_in);
ViStatus _VI_FUNC AuMT8820_Get_Wave_Memory_Phase_Error(ViSession instrSession, ViInt32 pos, ViInt32 n, ViChar _VI_FAR data[]);
ViStatus _VI_FUNC AuMT8820_Set_Window_Size(ViSession instrSession, ViInt32 size);
ViStatus _VI_FUNC AuMT8820_Get_Window_Size(ViSession instrSession,  ViInt32  _VI_FAR *size);


#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
